/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filewatcher.poller;

import com.aptana.filewatcher.poller.epl.DirectoryChangeListener;
import com.aptana.filewatcher.poller.epl.DirectoryWatcher;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PollingNotifier
implements IJNotify {
    private int id = 0;
    private Map<Integer, DirectoryWatcher> watchers = new HashMap<Integer, DirectoryWatcher>();

    public int addWatch(String path, final int mask, boolean watchSubtree, boolean recursive, final JNotifyListener listener) throws JNotifyException {
        DirectoryWatcher watcher = new DirectoryWatcher(new File(path), watchSubtree);
        watcher.addListener(new DirectoryChangeListener(){
            private Map<File, Long> files = new HashMap<File, Long>();

            public void startPoll() {
            }

            public void stopPoll() {
            }

            public boolean added(File file) {
                this.files.put(file, file.lastModified());
                if ((mask & 1) == 0) {
                    return false;
                }
                listener.fileCreated(0, file.getParent(), file.getName());
                return true;
            }

            public boolean removed(File file) {
                this.files.remove(file);
                if ((mask & 2) == 0) {
                    return false;
                }
                listener.fileDeleted(0, file.getParent(), file.getName());
                return true;
            }

            public boolean changed(File file) {
                this.files.put(file, file.lastModified());
                if ((mask & 4) == 0) {
                    return false;
                }
                listener.fileModified(0, file.getParent(), file.getName());
                return true;
            }

            public boolean isInterested(File file) {
                return true;
            }

            public Long getSeenFile(File file) {
                Long timestamp = this.files.get(file);
                Object resource = null;
                Path location = new Path(file.getAbsolutePath());
                resource = file.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)location) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
                Long resourceTimestamp = null;
                if (resource != null && resource.exists()) {
                    resourceTimestamp = resource.getLocalTimeStamp();
                }
                if (resourceTimestamp == null && timestamp == null) {
                    return null;
                }
                if (resourceTimestamp != null && (timestamp == null || resourceTimestamp > timestamp)) {
                    this.files.put(file, resourceTimestamp);
                    return resourceTimestamp;
                }
                this.files.put(file, timestamp);
                return timestamp;
            }
        });
        int thisId = this.id;
        this.watchers.put(this.id++, watcher);
        watcher.start();
        return thisId;
    }

    public boolean removeWatch(int wd) throws JNotifyException {
        DirectoryWatcher watcher = this.watchers.remove(wd);
        if (watcher == null) {
            return false;
        }
        watcher.dispose();
        return true;
    }
}

